/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.items.stacks.builders;

import com.google.common.base.Preconditions;
import net.impactdev.impactor.api.items.builders.AbstractStackBuilder;
import net.impactdev.impactor.api.items.builders.provided.SkullStackBuilder;
import net.impactdev.impactor.api.items.extensions.SkullStack;
import net.impactdev.impactor.minecraft.items.stacks.providers.ImpactorSkullStack;
import org.jetbrains.annotations.Nullable;

public class ImpactorSkullStackBuilder
extends AbstractStackBuilder<SkullStack, SkullStackBuilder>
implements SkullStackBuilder {
    public boolean isPlayer;
    @Nullable
    public SkullStack.SkullType type;
    @Nullable
    public String texture;
    @Nullable
    public String target;

    @Override
    public SkullStackBuilder mob(SkullStack.SkullType type) {
        this.isPlayer = false;
        this.type = type;
        return this;
    }

    @Override
    public SkullStackBuilder player(String spec, boolean texture) {
        if (texture) {
            this.texture = spec;
        } else {
            this.target = spec;
        }
        this.isPlayer = true;
        return this;
    }

    @Override
    public SkullStack build() {
        if (this.isPlayer) {
            Preconditions.checkArgument((this.texture != null || this.target != null ? 1 : 0) != 0, (Object)"Missing player head parameters");
        } else {
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Missing Mob skull parameter");
        }
        return new ImpactorSkullStack(this);
    }
}

